/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import technology.rocketjump.undermount.entities.components.AttachedLightSourceComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.Updatable;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.DoorwayPlacementMessage;
import technology.rocketjump.undermount.rendering.lighting.PointLight;

@Singleton
public class AttachedLightSourceProcessor
implements GameContextAware,
Updatable,
Telegraph {
    private final MessageDispatcher messageDispatcher;
    private GameContext gameContext;
    private Set<GridPoint2> tilesToCheck = new HashSet<GridPoint2>();

    @Inject
    public AttachedLightSourceProcessor(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        messageDispatcher.addListener(this, 804);
        messageDispatcher.addListener(this, 605);
        messageDispatcher.addListener(this, 607);
        messageDispatcher.addListener(this, 801);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 605: 
            case 607: 
            case 804: {
                GridPoint2 doorPosition = (GridPoint2)msg.extraInfo;
                this.markTilesToCheckAround(doorPosition);
                return true;
            }
            case 801: {
                DoorwayPlacementMessage message = (DoorwayPlacementMessage)msg.extraInfo;
                this.markTilesToCheckAround(message.getTilePosition());
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private void markTilesToCheckAround(GridPoint2 gridPosition) {
        for (int y = gridPosition.y - (int)PointLight.LIGHT_RADIUS; y <= gridPosition.y + (int)PointLight.LIGHT_RADIUS; ++y) {
            for (int x = gridPosition.x - (int)PointLight.LIGHT_RADIUS; x <= gridPosition.x + (int)PointLight.LIGHT_RADIUS; ++x) {
                this.tilesToCheck.add(new GridPoint2(x, y));
            }
        }
    }

    private boolean isOnMap(GridPoint2 positionToCheck) {
        if (this.gameContext == null) {
            return false;
        }
        TiledMap areaMap = this.gameContext.getAreaMap();
        return positionToCheck.x >= 0 && positionToCheck.x < areaMap.getWidth() && positionToCheck.y >= 0 && positionToCheck.y < areaMap.getHeight();
    }

    @Override
    public void update(float deltaTime) {
        if (this.gameContext == null) {
            return;
        }
        TiledMap areaMap = this.gameContext.getAreaMap();
        for (GridPoint2 tileToCheckPosition : this.tilesToCheck) {
            if (!this.isOnMap(tileToCheckPosition)) continue;
            MapTile tileToCheck = areaMap.getTile(tileToCheckPosition);
            for (Entity entity : tileToCheck.getEntities()) {
                AttachedLightSourceComponent component = entity.getComponent(AttachedLightSourceComponent.class);
                if (component == null) continue;
                component.setUpdateRequired();
            }
        }
        this.tilesToCheck.clear();
    }

    @Override
    public boolean runWhilePaused() {
        return true;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

